/*
 *  ESNetscapePlugin.h
 *  Flash'In'App
 *
 *  Copyright 2008 Eltima Software. All rights reserved.
 *
 *	Flash'In'App is free for non-commercial use.
 *	If you plan to integrate it in commercial software, please, make sure you are acquainted with the license terms and obtain the Commercial License.
 *	Please, contact Eltima at sales@eltima.com or visit http://mac.eltima.com
 */

#ifndef __LP64__
#include <Foundation/Foundation.h>

#include "npapi.h"
#include "npfunctions.h"

#if MAC_OS_X_VERSION_MAX_ALLOWED <= MAC_OS_X_VERSION_10_4
#define BUILDING_ON_TIGER 1
#endif

#ifdef BUILDING_ON_TIGER
typedef short ResFileRefNum;
#endif

@interface ESNetscapePlugin : NSObject
{
	id controlView;
	
	NPPluginFuncs pluginFuncs;
	NPNetscapeFuncs browserFuncs;
	
	uint16 pluginSize;
	uint16 pluginVersion;
	
	ResFileRefNum resourceRef;
	
	NSBundle *bundle;
	CFBundleRef cfBundle;

	NPP_NewProcPtr NPP_New;
	NPP_DestroyProcPtr NPP_Destroy;
	NPP_SetWindowProcPtr NPP_SetWindow;
	NPP_NewStreamProcPtr NPP_NewStream;
	NPP_DestroyStreamProcPtr NPP_DestroyStream;
	NPP_StreamAsFileProcPtr NPP_StreamAsFile;
	NPP_WriteReadyProcPtr NPP_WriteReady;
	NPP_WriteProcPtr NPP_Write;
	NPP_PrintProcPtr NPP_Print;
	NPP_HandleEventProcPtr NPP_HandleEvent;
	NPP_URLNotifyProcPtr NPP_URLNotify;
	NPP_GetValueProcPtr NPP_GetValue;
	NPP_SetValueProcPtr NPP_SetValue;
	NPP_ShutdownProcPtr NPP_Shutdown;
	NPP_GetJavaClassProcPtr NPP_GetJavaClass;

  NP_DisableLocalSecurityPtr NP_DisableLocalSecurity;
  NP_EnforceLocalSecurityPtr NP_EnforceLocalSecurity;

	BOOL isLoaded;
	BOOL needsUnload;
	unsigned int instanceCount;
}

/*
 *	init-method,
 *	pluginPath - path to Netscape plugin
 */
- (id) initWithPath:(NSString *)pluginPath;

/*
 *	methods of setting and getting
 *	controlView - view holding the plugin
 */
- (id) controlView;
- (void) setControlView:(id)value;

- (BOOL)load;

/*
 * Netscape plug-in packages must be explicitly opened and closed by each plug-in instance.
 * This is to protect Netscape plug-ins from being unloaded while they are in use.
 */
- (void)open;
- (void)close;

- (NPP_NewProcPtr)NPP_New;
- (NPP_DestroyProcPtr)NPP_Destroy;
- (NPP_SetWindowProcPtr)NPP_SetWindow;
- (NPP_NewStreamProcPtr)NPP_NewStream;
- (NPP_WriteReadyProcPtr)NPP_WriteReady;
- (NPP_WriteProcPtr)NPP_Write;
- (NPP_StreamAsFileProcPtr)NPP_StreamAsFile;
- (NPP_DestroyStreamProcPtr)NPP_DestroyStream;
- (NPP_HandleEventProcPtr)NPP_HandleEvent;
- (NPP_URLNotifyProcPtr)NPP_URLNotify;
- (NPP_GetValueProcPtr)NPP_GetValue;
- (NPP_SetValueProcPtr)NPP_SetValue;
- (NPP_PrintProcPtr)NPP_Print;

/*
 * only for Flash Plugin
 */
- (NP_DisableLocalSecurityPtr) NP_DisableLocalSecurity;
- (NP_EnforceLocalSecurityPtr) NP_EnforceLocalSecurity;

@end

#endif
